package testsUnitaires;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import m.Entree;

class EntreeTest {
	
    private Entree entree;

//S'exécutera avant chaque test
    @BeforeEach
    void instanceEntree() {
    	//Instanciation d'une entree quelconque
    	entree = new Entree("Carottes râpées", 1.3);
    }
    

//Vérifie si les getters et setters fonctionnent correctement
    @Test
    void testGetNomEntree() {
    	//Compare si le nom de l'entree est bien carottes râpées
        assertEquals("Carottes râpées", entree.getNomEntree());
    }

    @Test
    void testSetNomEntree() {
    	entree.setNomEntree("Betteraves");
      //Compare si le nom de l'entree a bien été modifié en betteraves
        assertEquals("Betteraves", entree.getNomEntree());
    }

    @Test
    void testGetPrixEntree() {
        assertEquals(1.3, entree.getPrixEntree());
    }

    @Test
    void testSetPrixEntree() {
    	entree.setPrixEntree(3.0);
        assertEquals(0.5, entree.getPrixEntree());
    }
}
